	try
	{
		system.require('ObjTree.module');
		const iconvLite = require('./iconv-lite/lib/index');

		var VERSION = '1.0',
			PROGRAM = 'BASIS';

		function isEqualFloat(v1, v2) {
			return Math.abs(v1 - v2) < 0.001;
		}

		function rnd2(val) {
			result = parseFloat(val).toFixed(2);
			if (result == -0)
				result = 0;
			return result;
		}

		function rnd1(val) {
			return parseFloat(val).toFixed(1);
		}

		function Hole(Id,Position, EndPosition, Direction, obj,Contour) {
			this.Id = Id;
			this.Position = Position;
			this.EndPosition = EndPosition;
			this.Direction = Direction;
			this.obj = obj;
			this.contour = Contour
			this.used = false;
		};


		var Doc = {};
		Doc.document = {element: []};

		var holes = [];

		function SetMetaInfo(){
			Doc.document.MetaBasis = {
				version: VERSION,
				program: PROGRAM
			};
		}

		function GatherHolesInfo(Model){
			let count = 1;
			for (var i = 0; i < Model.Count; i++) {
				GetObjType(node) !== 'furniture'
				var node = Model[i];
				if (GetObjType(node) !== 'furniture') 
				{
					CheckAndGoToRecurtion(node);
					continue;
				}

				for (var j = 0; j < node.Holes.Count; j++) {
					var hole = node.Holes[j];+
					holes.push(new Hole(count,node.ToGlobal(hole.Position), node.ToGlobal(hole.EndPosition()), node.NToGlobal(hole.Direction), hole, hole.Contour));
					count++;
				}
				checkAndRemoveMinifix(node);
				CheckAndGoToRecurtion(node);
			}
		}

		function CheckAndGoToRecurtion(node){
			if (node.Count){
				if (node.Count > 0){
					GatherHolesInfo(node);
				}
			}
		}

		function GetProperties(_object) {
			try
			{
				let result = _object.constructor.name + ':\n';
		
				for (let prop in _object) {
					result += `${prop}\n`;
				}
			
				alert(result);
			}
			catch(ex) {alert(ex)}
		}

		function GatherHolesInfoV2(Model)
		{
			try
			{
				let count = 1;
				Model.forEachPanel(function(panel){
					let fasts = panel.FindConnectedFasteners();
					for (let i = 0; i < fasts.length; i++) {
						// GetProperties(fasts[0]);
						let holesz = fasts[i].Holes;
						if (holesz && holesz.Count > 0) {
							for (let j = 0; j < holesz.Count; j++) {
									const hole = holesz[j];
									// GetProperties(hole);
									const holeNew = new Hole(count,panel.ToGlobal(hole.Position), panel.ToGlobal(hole.EndPosition()), panel.NToGlobal(hole.Direction), hole, hole.Contour);
									holes.push(holeNew);
									count++;
								}
							}
					}
				});
			} catch (ex)
			{
				alert("   : " + ex)
			}
		}  

		function checkAndRemoveMinifix(node)
		{
			if (node.DatumMode === 2 && node.Holes.Count == 3)
				{
					var oneHoleIsPerp = false;
					var oneHoleIsParalel = false;
					for (var z = 0; z < node.Holes.Count; z++) {
						var hole1 = node.Holes[z];
						for (var c = 0; c < node.Holes.Count; c++) {
							var hole2 = node.Holes[c];
							if (z !== c) {
								if (areCylindersPerpendicular(hole1.Direction,hole2.Direction))
								{
									oneHoleIsPerp = true;
									z = c;
								}
								if(areCylindersParalel(hole1.Direction,hole2.Direction))
								{
									oneHoleIsParalel = true;
									z = c;
								}
							}
						}
					}
					if (oneHoleIsPerp && oneHoleIsParalel)
					{
						let lastThreeHoles = holes.slice(-3);

						let maxDiameterHole = lastThreeHoles.reduce((max, hole) => {
							return (hole.obj.Diameter > max.obj.Diameter) ? hole : max;
						});

						let maxDepthHole = lastThreeHoles.reduce((max, hole) => {
							return (hole.obj.Depth > max.obj.Depth) ? hole : max;
						});

						let remainingHole = lastThreeHoles.find(hole => hole !== maxDepthHole && hole !== maxDiameterHole);

						holes.length = holes.length - 3;
						holes.push(remainingHole); 
						holes.push(maxDepthHole); 
					}
				}
		}

		function areCylindersPerpendicular(direction1, direction2) {
			const dotProduct = direction1.x * direction2.x + direction1.y * direction2.y + direction1.z * direction2.z;
			
			const arePerpendicular = Math.round(dotProduct,5) === 0;
		
			return arePerpendicular;
		}

		function areCylindersParalel(direction1, direction2) {
			const dotProduct = direction1.x * direction2.x + direction1.y * direction2.y + direction1.z * direction2.z;
			//   
			const length1 = Math.sqrt(direction1.x ** 2 + direction1.y ** 2 + direction1.z ** 2);
			const length2 = Math.sqrt(direction2.x ** 2 + direction2.y ** 2 + direction2.z ** 2);
		
			// ,     
			if (length1 === 0 || length2 === 0) {
				return false; //    - 
			}
			//     
			const cosTheta = dotProduct / (length1 * length2);

			// ,     (  1  -1)
			const areParallel = Math.abs(cosTheta) === 1;
		
			return areParallel;
		}

		// function areHolesIntersecting(bore1, bore2) {
		// 	const tolerance = 0.01;
		// 	//alert(`${bore1.x} | ${bore1.y} | ${bore1.z}    |    ${bore2.x} | ${bore2.y} | ${bore2.z} `)
		// 	var isFirstButt = false;
		// 	var isSecondButt = false;

		// 	if (Math.abs(bore1.Direction.x) > tolerance || Math.abs(bore1.Direction.y) > tolerance) {
		// 		isFirstButt = true;
		// 	}
		// 	if (Math.abs(bore2.Direction.x) > tolerance || Math.abs(bore2.Direction.y) > tolerance) {
		// 		isSecondButt = true;
		// 	}
		// 	if(true)
		// 	{
		// 		const y1 = bore1.Position.y;
		// 		const x1 = bore1.Position.x;
		// 		const z1 = bore1.Position.z;
		// 		const y2 = bore2.Position.y;
		// 		const x2 = bore2.Position.x;
		// 		const z2 = bore2.Position.z;  
		// 		const depth = parseFloat(bore1.obj.Depth);
		// 		const depth2 = parseFloat(bore2.obj.Depth);
		// 		const deametr = bore1.obj.Diameter;
		// 		const deametr2 = bore2.obj.Diameter;
		// 		const isIntersectingZY = y1+depth <= y2 - deametr2/2 && (z2 < z1 + deametr || z2 + deametr < z1);
		// 		const isIntersectingYX = y2+depth <= y1 - deametr/2 && (x2+deametr < x1 -depth);
		// 		return isIntersectingYX;
		// 	}
		// 	else if (isSecondButt && !isFirstButt)
		// 	{
		// 		const y1 = bore1.holePos.y;
		// 		const x1 = bore1.holePos.x;
		// 		const z1 = bore1.holePos.z1;
		// 		const y2 = bore2.holePos.y;
		// 		const x2 = bore2.holePos.x;
		// 		const z2 = bore2.holePos.x;	
		// 		const depth = parseFloat(bore1.dp);
		// 		const depth2 = parseFloat(bore2.dp);
		// 		const deametr = bore1.d;
		// 		const deametr2 = bore2.d;
		// 		return y2+depth2 >= y1 - deametr/2;
		// 	}
		// }

		function GatherPanelInfo(Model) {
			for (var i = 0; i < Model.Count; i++) {
				var node = Model[i];

				if (node.List) {
					GatherPanelInfo(node)
				} else {
					if(!(node instanceof TFurnPanel))continue;
					//console.log(node.Name);
					if (GetObjType(node) !== 'panel') continue;
					var line = {};

					//console.log(node);
					//console.log(node.constructor.name);

					line['-id'] = i;

					line.name = node.Name;
					line.materialName = node.MaterialName;

					/*line.gSize = { //  (  GMax  GMin).
						x: Math.round(node.GSize.x),
						y: Math.round(node.GSize.y),
						z: Math.round(node.GSize.z)
					};
					line.gMin = { //  ,       .
						x: Math.round(node.GMin.x),
						y: Math.round(node.GMin.y),
						z: Math.round(node.GMin.z)
					};
					line.gMax = { //  ,       .
						x: Math.round(node.GMax.x),
						y: Math.round(node.GMax.y),
						z: Math.round(node.GMax.z)
					};
					line.gabMin = { //  ,       .
						x: Math.round(node.GabMin.x),
						y: Math.round(node.GabMin.y),
						z: Math.round(node.GabMin.z)
					};

					line.gabMax = { //  ,       .
						x: Math.round(node.GabMax.x),
						y: Math.round(node.GabMax.y),
						z: Math.round(node.GabMax.z)
					};  */

                    //alert('  W: ' + node.ContourWidth + '\n   H: ' + node.ContourHeight);

					line.contourWidth = node.ContourWidth; // .
					line.contourHeight = node.ContourHeight; // .
					line.thickness = Math.round(node.Thickness); // .
					line.textureOrientation = node.TextureOrientation;
					var part = GetButts(node);
					line.edges = GetEdges(part.el, node);
					const { heightDif, widthDif } = ClipPanel(line);
					line.cuts = GetCuts(node.Cuts, line,node,widthDif);
					line.holes = GetHoles(node, part,widthDif,line.contourWidth,heightDif,line.contourHeight);

					Doc.document.element.push(line);
				}
			}
		}

		function   ClipPanel(line) {
			const firstlyWidth = Math.round(line.contourWidth);
			const firstlyHeight =  Math.round(line.contourHeight);

			for (var i = 0; i < line.edges.length; i += 1) {
				if (line.edges[i].pos === 'top' || line.edges[i].pos === 'bottom') {
					line.contourHeight = line.contourHeight - (line.edges[i].clipPanel ? line.edges[i].thickness : 0) - line.edges[i].allowance;
				} else if (line.edges[i].pos === 'left' || line.edges[i].pos === 'right') {
					line.contourWidth = line.contourWidth - (line.edges[i].clipPanel ? line.edges[i].thickness : 0)  - line.edges[i].allowance;
				}
				delete line.edges[i].clipPanel;
				delete line.edges[i].allowance;
			}
			line.contourWidth = Math.round(line.contourWidth);
			line.contourHeight = Math.round(line.contourHeight);
            
			const heightDif = Math.round(firstlyHeight) - line.contourHeight;
			const widthDif = Math.round(firstlyWidth) - line.contourWidth;
			return {heightDif, widthDif};
		}

		function GetEdges( gabEdges,node) {
			var res = [];

			let flipEdges = false;
			for (var i = 0; i < holes.length; i++) {
						var hole,
						holePos,
						holeDir,
						hz,

				hole = holes[i];
				holePos = node.GlobalToObject(hole.Position);
				if (holePos.z < -(hole.obj.Depth + node.Thickness) || (holePos.z > hole.obj.Depth + node.Thickness))
					continue;
				holeDir = node.NToObject(hole.Direction);

				if (rnd2(Math.abs(holeDir.z)) == 1 && node.Contour.IsPointInside(holePos)) {
					hz = holePos.z;

					if (holeDir.z > 0.001) {
						if (hz <= 0.001 && (hz + hole.obj.Depth) > 0) {
							depth = rnd2(hz + hole.obj.Depth);
							if (Math.round(node.Thickness * 10) > Math.round(depth * 10))
							{
								flipEdges = true;
								break;
							}
						}
					}
				}
			}

			for(var i = 0; i < 4; i += 1){

				if(!gabEdges[i]) continue;
				var ge = gabEdges[i], pos;

				if (i === 0) {
					pos = 'bottom';
				} else if (i === 1) {
					pos = 'top';
				} else if (i === 2) {
					if (flipEdges) pos = 'right';
					else pos = 'left';
				} else if (i === 3) {
					if (flipEdges) pos = 'left';
					else pos = 'right';
				}

				var butt = {
					sign: ge.sign,
					thickness: ge.t,
					allowance: ge.allowance,
					clipPanel: ge.clipPanel,
					pos: pos
				}
				if(ge.m){
					butt.material = ge.m;
				}

				res.push(butt);
			}
			return res;
		}

		function GetMinMax (node){
			var minX = 1000000;
			var minY = 1000000;
			var maxX = -1000000;
			var maxY = -1000000;
			if (node.Contour.Count > 0) {
				for (var i = 0; i < node.Contour.Count; i++) {
					elem = node.Contour[i];
					if (elem.ElType == 1) {
						minX = Math.min(minX, elem.Pos1.x);
						minY = Math.min(minY, elem.Pos1.y);
						maxX = Math.max(maxX, elem.Pos1.x);
						maxY = Math.max(maxY, elem.Pos1.y);
						minX = Math.min(minX, elem.Pos2.x);
						minY = Math.min(minY, elem.Pos2.y);
						maxX = Math.max(maxX, elem.Pos2.x);
						maxY = Math.max(maxY, elem.Pos2.y);
					} else if (elem.ElType == 2) {

						if (elem.AngleOnArc(Math.PI) == true) {
							minX = Math.min(minX, elem.Center.x - elem.ArcRadius());
						} else {
							minX = Math.min(minX, elem.Pos1.x);
							minX = Math.min(minX, elem.Pos2.x);
						}

						if (elem.AngleOnArc(0) || elem.AngleOnArc(Math.PI * 2.0)) {
							maxX = Math.max(maxX, elem.Center.x + elem.ArcRadius());
						} else {
							maxX = Math.max(maxX, elem.Pos1.x);
							maxX = Math.max(maxX, elem.Pos2.x);
						}
						if (elem.AngleOnArc((Math.PI * 3.0) / 2.0)) {
							minY = Math.min(minY, elem.Center.y - elem.ArcRadius());
						} else {
							minY = Math.min(minY, elem.Pos1.y);
							minY = Math.min(minY, elem.Pos2.y);
						}
						if (elem.AngleOnArc(Math.PI / 2.0)) {
							maxY = Math.max(maxY, elem.Center.y + elem.ArcRadius());
						} else {
							maxY = Math.max(maxY, elem.Pos1.y);
							maxY = Math.max(maxY, elem.Pos2.y);
						}
					} else if (elem.ElType == 3) {
						minX = Math.min(minX, elem.Center.x - elem.CirRadius);
						minY = Math.min(minY, elem.Center.y - elem.CirRadius);
						maxX = Math.max(maxX, elem.Center.x + elem.CirRadius);
						maxY = Math.max(maxY, elem.Center.y + elem.CirRadius);
					}
				}
			} else {
				minX = node.GMin.x;
				minY = node.GMin.y;
				maxX = node.GMax.x;
				maxY = node.GMax.y;
			}


			return {
				minX: minX,
				minY: minY,
				maxX: maxX,
				maxY: maxY
			};
		}

		function GetButts(node){
			function getButtForLine(node, elem) {
				var res = null;
				if(elem.Tag === undefined){
					res = elem.Data.Butt;
				} else if(elem.Tag >= 0){
					res = node.Butts[elem.Tag];
				}

				return res;
			}

			function OpEdge(Material, Thickness, Width, ClipPanel, Allowance, Sign) {
				this.name = Material;
				this.t = Thickness;
				this.w = Width;
				this.clipPanel = ClipPanel;
				this.allowance = Allowance;
				this.sign = Sign;
				this.parts = [];
			}
			var operationId = 1;
			var opEdges = [];

			function addEdge(part, Material, Thickness, Width, ClipPanel, Allowance, Sign) {
				var opEdge = null;
				for (var i = 0; i < opEdges.length; i++) {
					var op = opEdges[i];
					if (Material == op.name && Thickness == op.t && Width == op.w) {
						opEdge = op;
						break;
					}
				}
				if (opEdge == null) {
					opEdge = new OpEdge(Material, Thickness, Width, ClipPanel, Allowance, Sign);
					opEdge.id = operationId++;
					opEdges.push(opEdge);
				}
				for (var i = 0; i < opEdge.parts.length; i++)
					if (opEdge.parts[i] == part)
						return opEdge;
				opEdge.parts.push(part);
				return opEdge;
			};

			var MM = GetMinMax(node),
				minX = MM.minX,
				minY = MM.minY,
				maxX = MM.maxX,
				maxY = MM.maxY;

			var part = {};
			part.contour = [];
			part.el = [];

			if (node.Contour.Count > 0) {
				var contourItem, srcContour, dstContours;
				//    
				srcContour = node.Contour.MakeCopy();
				for (var j = 0; j < srcContour.Count; j++) {
					srcContour[j].Tag = -1;
				}
				for (var j = 0; j < node.Butts.Count; j++){
					srcContour[node.Butts[j].ElemIndex].Tag = j;
				}
				// 
				dstContours = [];
				var contourClear = srcContour.MakeCopy();
				contourClear.Clear();
				for (var j = 0; j < srcContour.Count; j++) {
					if (srcContour[j].ElType == 3) {
						contourItem = contourClear.MakeCopy();
						contourItem.Add(srcContour[j]);
						dstContours.push(contourItem.MakeCopy());
						srcContour.Delete(srcContour[j]);
						j--;
					}
				}

				//   
				if (srcContour.Count > 0) {
					srcContour.OrderContours();
					while (srcContour.Count > 0) {
						var elem1 = srcContour[srcContour.Count - 1].MakeCopy();
						srcContour.Delete(srcContour[srcContour.Count - 1]);
						contourItem = contourClear.MakeCopy();
						contourItem.Add(elem1);
						dstContours.push(contourItem);
						start: for (var k = 0; k < contourItem.Count; k++) {
							var elem2 = contourItem[k];
							for (var j = 0; j < srcContour.Count; j++) {
								elem1 = srcContour[j].MakeCopy();
								if (isEqualFloat(elem1.Pos2.x, elem2.Pos1.x) && isEqualFloat(elem1.Pos2.y, elem2.Pos1.y) ||
									isEqualFloat(elem1.Pos1.x, elem2.Pos2.x) && isEqualFloat(elem1.Pos1.y, elem2.Pos2.y) || isEqualFloat(elem1.Pos1.x, elem2.Pos1.x) && isEqualFloat(elem1.Pos1.y, elem2.Pos1.y) ||
									isEqualFloat(elem1.Pos2.x, elem2.Pos2.x) && isEqualFloat(elem1.Pos2.y, elem2.Pos2.y)
								) {
									contourItem.Add(elem1);
									srcContour.Delete(srcContour[j]);
									continue start;
								}
							}
						}
					}
				}

				for (var jc = 0; jc < dstContours.length; jc++) {
					contourItem = dstContours[jc];
					contourItem.OrderContours();
					contourItem.clockOtherWise = false;

					for (var ic = 0; ic < dstContours.length; ic++)
						if (ic != jc) {
							var p = contourItem[0].ElType == 3 ? contourItem[0].Center : contourItem[0].Pos1;
							contourItem.clockOtherWise = contourItem.clockOtherWise || (contourItem.IsInContour === undefined ? dstContours[ic].IsPointInside(p, 0, true) : contourItem.IsInContour(dstContours[ic]));
						}
					if (contourItem.IsClosedContour() && contourItem.IsClockOtherWise())
						contourItem.InvertDirection();

					var contElement = {};
					var cntRect = 0;
					var cntr = [];

					for (var j = 0; j < contourItem.Count; j++) {
						cntr.push(contourItem[j]);
					}

					var elCan=[];
					elCan[0]=true;
					elCan[1]=true;
					elCan[2]=true;
					elCan[3]=true;
					var elem, butt;
					for (var j = 0; j < cntr.length; j++) {
						elem = cntr[j];
						butt = getButtForLine(node, elem);
						var contourLen = elem.ObjLength();
						if (elem.ElType == 1) {
							if (rnd1(elem.Pos1.x - minX) == 0 && rnd1(elem.Pos2.x - minX) == 0 && rnd1(contourLen - part.cw) == 0) {
								cntRect++;
								if (butt != null) part.el[2] = addEdge(part, butt.Material, butt.Thickness, butt.Width, butt.ClipPanel, butt.Allowance, butt.Sign);
								cntr[j] = null;
								elCan[2]=false;
							} else if (rnd1(elem.Pos1.y - maxY) == 0 && rnd1(elem.Pos2.y - maxY) == 0 && rnd1(contourLen - part.cl) == 0) {
								cntRect++;
								if (butt != null) part.el[0] = addEdge(part, butt.Material, butt.Thickness, butt.Width, butt.ClipPanel, butt.Allowance, butt.Sign);
								cntr[j] = null;
								elCan[0]=false;
							} else if (rnd1(elem.Pos1.x - maxX) == 0 && rnd1(elem.Pos2.x - maxX) == 0 && rnd1(contourLen - part.cw) == 0) {
								cntRect++;
								if (butt != null) part.el[3] = addEdge(part, butt.Material, butt.Thickness, butt.Width, butt.ClipPanel, butt.Allowance, butt.Sign);
								cntr[j] = null;
								elCan[3]=false;
							} else if (rnd1(elem.Pos1.y - minY) == 0 && rnd1(elem.Pos2.y - minY) == 0 && rnd1(contourLen - part.cl) == 0) {
								cntRect++;
								if (butt != null) part.el[1] = addEdge(part, butt.Material, butt.Thickness, butt.Width, butt.ClipPanel, butt.Allowance, butt.Sign);
								cntr[j] = null;
								elCan[1]=false;
							}
						}
					}
					for (var j = 0; j < cntr.length; j++) {
						elem = cntr[j];
						if (elem == null || elem.ElType > 1)
							continue;
						butt = getButtForLine(node, elem);

						if (butt != null) {
							if (part.el[2] == null && (rnd1(elem.Pos1.x - minX) == 0 && rnd1(elem.Pos2.x - minX) == 0)) {
								part.el[2] = addEdge(part, butt.Material, butt.Thickness, butt.Width, butt.ClipPanel, butt.Allowance, butt.Sign);
								cntr[j] = null;
							} else
							if (part.el[0] == null && (rnd1(elem.Pos1.y - maxY) == 0 && rnd1(elem.Pos2.y - maxY) == 0)) {
								part.el[0] = addEdge(part, butt.Material, butt.Thickness, butt.Width, butt.ClipPanel, butt.Allowance, butt.Sign);
								cntr[j] = null;
							} else
							if (part.el[3] == null && (rnd1(elem.Pos1.x - maxX) == 0 && rnd1(elem.Pos2.x - maxX) == 0)) {
								part.el[3] = addEdge(part, butt.Material, butt.Thickness, butt.Width, butt.ClipPanel, butt.Allowance, butt.Sign);
								cntr[j] = null;
							} else
							if (part.el[1] == null && (rnd1(elem.Pos1.y - minY) == 0 && rnd1(elem.Pos2.y - minY) == 0)) {
								part.el[1] = addEdge(part, butt.Material, butt.Thickness, butt.Width, butt.ClipPanel, butt.Allowance, butt.Sign);
								cntr[j] = null;
							}
						}
					}


					for (var j = 0; j < cntr.length; j++) {
						elem = cntr[j];
						if (elem == null)
							continue;
						butt = getButtForLine(node, elem);

						if (butt != null) {
							if (elem.ElType == 1) {
								if (part.el[2] == null && elCan[2] && (rnd1(elem.Pos1.x - minX) == 0 || rnd1(elem.Pos2.x - minX) == 0))
									part.el[2] = addEdge(part, butt.Material, butt.Thickness, butt.Width, butt.ClipPanel, butt.Allowance, butt.Sign);
								if (part.el[0] == null && elCan[0] && (rnd1(elem.Pos1.y - maxY) == 0 || rnd1(elem.Pos2.y - maxY) == 0))
									part.el[0] = addEdge(part, butt.Material, butt.Thickness, butt.Width, butt.ClipPanel, butt.Allowance, butt.Sign);
								if (part.el[3] == null && elCan[3]  && (rnd1(elem.Pos1.x - maxX) == 0 || rnd1(elem.Pos2.x - maxX) == 0))
									part.el[3] = addEdge(part, butt.Material, butt.Thickness, butt.Width, butt.ClipPanel, butt.Allowance, butt.Sign);
								if (part.el[1] == null && elCan[1] && (rnd1(elem.Pos1.y - minY) == 0 || rnd1(elem.Pos2.y - minY) == 0))
									part.el[1] = addEdge(part, butt.Material, butt.Thickness, butt.Width, butt.ClipPanel, butt.Allowance, butt.Sign);
							} else if (elem.ElType == 2) {
								var r = getDistance(elem.Pos1.x, elem.Pos1.y, elem.Center.x, elem.Center.y);
								if (part.el[2] == null && elCan[2] && (rnd1(elem.Pos1.x - minX) == 0 || rnd1(elem.Pos2.x - minX) == 0 || Math.abs(rnd1((elem.Center.x - r) - minX)) < 3))
									part.el[2] = addEdge(part, butt.Material, butt.Thickness, butt.Width, butt.ClipPanel, butt.Allowance, butt.Sign);
								if (part.el[0] == null && elCan[0] && (rnd1(elem.Pos1.y - maxY) == 0 || rnd1(elem.Pos2.y - maxY) == 0 || Math.abs(rnd1((elem.Center.y + r) - maxY)) < 3))
									part.el[0] = addEdge(part, butt.Material, butt.Thickness, butt.Width, butt.ClipPanel, butt.Allowance, butt.Sign);
								if (part.el[3] == null && elCan[3] && (rnd1(elem.Pos1.x - maxX) == 0 || rnd1(elem.Pos2.x - maxX) == 0 || Math.abs(rnd1((elem.Center.x + r) - maxX)) < 3))
									part.el[3] = addEdge(part, butt.Material, butt.Thickness, butt.Width, butt.ClipPanel, butt.Allowance, butt.Sign);
								if (part.el[1] == null && elCan[1] && (rnd1(elem.Pos1.y - minY) == 0 || rnd1(elem.Pos2.y - minY) == 0 || Math.abs(rnd1((elem.Center.y - r) - minY)) < 3))
									part.el[1] = addEdge(part, butt.Material, butt.Thickness, butt.Width, butt.ClipPanel, butt.Allowance, butt.Sign);
							} else if (elem.ElType == 3) {
								part.el[0] = addEdge(part, butt.Material, butt.Thickness, butt.Width, butt.ClipPanel, butt.Allowance, butt.Sign);
								part.el[1] = addEdge(part, butt.Material, butt.Thickness, butt.Width, butt.ClipPanel, butt.Allowance, butt.Sign);
								part.el[2] = addEdge(part, butt.Material, butt.Thickness, butt.Width, butt.ClipPanel, butt.Allowance, butt.Sign);
								part.el[3] = addEdge(part, butt.Material, butt.Thickness, butt.Width, butt.ClipPanel, butt.Allowance, butt.Sign);
							}
						}
					}

					if (cntRect < 4) {
						var contour = {};
						contour.path = [];
						part.contour.push(contour);
						contour.clockOtherWise = contourItem.clockOtherWise;
						contour.inner = contourItem.clockOtherWise;
						for (var j = 0; j < contourItem.Count; j++) {
							var elem = contourItem[j];
							if (elem.ElType != 3 && rnd1(elem.Pos1.x - elem.Pos2.x) == 0 && rnd1(elem.Pos1.y - elem.Pos2.y) == 0)
								continue;
							var contElement = {};
							contElement.line = false;
							contElement.Type = elem.ElType;
							contElement.lineSideFull = false;
							var contourLen = elem.ObjLength();

							if (elem.ElType == 1) {
								contElement.sx = elem.Pos1.x - minX;
								contElement.sy = elem.Pos1.y - minY;
								contElement.ex = elem.Pos2.x - minX;
								contElement.ey = elem.Pos2.y - minY;
								//Left Right
								if (rnd1(contElement.sx) == 0 && rnd1(contElement.ex) == 0 || rnd1(elem.Pos1.x - maxX) == 0 && rnd1(elem.Pos2.x - maxX) == 0) {
									contElement.lineSide = true;
									contElement.lineSideFull = rnd1(contourLen - part.cw) == 0;
								}
								//Top Bottom
								if (rnd1(elem.Pos1.y - maxY) == 0 && rnd1(elem.Pos2.y - maxY) == 0 || rnd1(contElement.sy) == 0 && rnd1(contElement.ey) == 0) {
									contElement.lineSide = true;
									contElement.lineSideFull = rnd1(contourLen - part.cl) == 0;
								}
								contElement.sy = part.cw - contElement.sy;
								contElement.ey = part.cw - contElement.ey;
								contour.path.push(contElement);
							} else if (elem.ElType == 2) {
								contElement.cx = elem.Center.x - minX;
								contElement.cy = part.cw - (elem.Center.y - minY);
								contElement.sx = elem.Pos1.x - minX;
								contElement.sy = part.cw - (elem.Pos1.y - minY);
								contElement.sa = (elem.Pos1Angle() * 180.0) / Math.PI;
								contElement.ex = elem.Pos2.x - minX;
								contElement.ey = part.cw - (elem.Pos2.y - minY);
								contElement.ea = (elem.Pos2Angle() * 180.0) / Math.PI;
								contElement.r = elem.ArcRadius();
								contElement.dir = !elem.ArcDir;
								contour.path.push(contElement);
							} else if (elem.ElType == 3) {
								contElement.cx = elem.Center.x - minX;
								contElement.cy = part.cw - (elem.Center.y - minY);
								contElement.r = elem.CirRadius;
								contElement.dir = false;
								contour.path.push(contElement);
							} else {
								alert('  ');
							}
						}

					}
				}
			}

			return part;
		}


		function GetHoles(node, part1,widthDif, widthLenght, lenghtDif, lenghtLenght) {
			var part = {};
			part.el = part1.el;
			part.bFront = [];
			part.bBack = [];
			part.cFront = [];
			part.cBack = [];
			part.cl = node.ContourWidth;
			part.cw = node.ContourHeight;
			part.thick = node.Thickness;
			part.contour = part1.contour;

			var bThrough = [],
				bHor = [],
				cThrough = [];

			var MM = GetMinMax(node),
				minX = MM.minX,
				minY = MM.minY,
				maxX = MM.maxX,
				maxY = MM.maxY;

			function Bore(plane, d, x, y, z, dp,holeDir,holePos) {
				//0:  XY (
				// 1:  YZ 
				// 2:  XZ 
				// 3:  XY 
				// 4:  YZ 
				// 5:  XZ
				this.plane = plane;
				this.d = d;
				this.x = x;
				this.y = y;
				this.z = z;
				this.dp = dp;
				this.holeDir = holeDir;
				this.holePos = holePos;

				// const properties = [
				// 	`plane: ${plane}`,
				// 	`d: ${d}`,
				// 	`x: ${x}`,
				// 	`y: ${y}`,
				// 	`z: ${z}`,
				// 	`dp: ${dp}`,
				// 	`holeDir: ${holeDir}`,
				// 	`holePos: ${holePos}`
				// ].join('\n');  //    

				// alert(" :\n" + properties);
			};

			function compare(v1, v2) {
				if (Math.abs(v1 - v2) < 0.001)
					return 0;
				else
					return v1 > v2 ? 1 : -1;
			}

			function sortBores(b1, b2) {
				r = compare(b1.plane, b2.plane);
				if (r != 0)
					return r;

				r = compare(b1.d, b2.d);
				if (r != 0)
					return r;

				r = compare(b1.x, b2.x);
				if (r != 0)
					return r;
				r = compare(b1.y, b2.y);
				if (r != 0)
					return r;
				r = compare(b1.z, b2.z);
				if (r != 0)
					return r;

				r = compare(b1.dp, b2.dp);
				if (r != 0)
					return r;

				return 0;
			}
			
			for (var i = 0; i < holes.length; i++) {
				var hole,
				holePos,
				holeDir,
				hz,
				depth,
				b;

				hole = holes[i];
				if (hole.used) continue;
				holePos = node.GlobalToObject(hole.Position);
				if (holePos.z < -(hole.obj.Depth + node.Thickness) || (holePos.z > hole.obj.Depth + node.Thickness))
					continue;
				holeDir = node.NToObject(hole.Direction);
				if (rnd2(Math.abs(holeDir.z)) == 1 && node.Contour.IsPointInside(holePos)) {
					hz = holePos.z;
					if (holeDir.z > 0.001) {
						if (hz <= 0.001 && (hz + hole.obj.Depth) > 0) {
							depth = hz + hole.obj.Depth;
                            // alert('---');
                            // alert('(holePos.x - minX): '+(holePos.x - minX));
                            // alert('(widthLenght/2): '+(widthLenght/2));
                            
                            //alert('(((holePos.x - minX) - (widthLenght/2) > 0) ? widthDif : 0): ' + (((holePos.x - minX) - (widthLenght/2) < 0) ? widthDif : 0))
                            // alert('(holePos.x - minX): ' +(holePos.x - minX));
                            // alert('((widthLenght/2)): ' +(widthLenght/2));
                            // alert('---');
							//- (((holePos.x - minX) - (widthLenght/2) < 0) ? widthDif : 0)
    
							b = new Bore(5, hole.obj.Diameter,(holePos.x - minX) - (((holePos.x - minX) - (widthLenght/2) > 0) ? widthDif : 0) , ((part.cw - holePos.y + minY) - (((holePos.y - minY) - (lenghtLenght/2) < 0) ? lenghtDif : 0)) , 0, rnd2(depth),holeDir,holePos);							if (Math.round(part.thick * 10) > Math.round(b.dp * 10))
								part.bBack.push(b);
							else {
								bThrough.push(b);
							}
							hole.used = isEqualFloat(hz, 0) && (node.Thickness >= hole.obj.Depth);

						}
						continue;
					} else {
						//system.log("B:"+node.Name+"   "+hz+"  "+node.Thickness+"    "+hole.obj.Depth+" "+((hz-node.Thickness)>=0) +"  "+( hole.obj.Depth-(hz-node.Thickness)));
						depth = hole.obj.Depth - (hz - node.Thickness);
						if ((hz - node.Thickness) >= -0.001 && depth >= 0.001) {
							b = new Bore(4, hole.obj.Diameter, (holePos.x - minX) - (((holePos.x - minX) - (widthLenght/2) > 0) ? widthDif : 0), part.cw - holePos.y + minY /*-widthDif*/, 0, rnd2(depth),holeDir,holePos);
							if (Math.round(part.thick * 10) > Math.round(b.dp * 10))
								part.bFront.push(b);
							else
								bThrough.push(b);
							hole.used = isEqualFloat(hz, node.Thickness) && (node.Thickness >= hole.obj.Depth);
						}
						continue;
					}
				}
				if (rnd2(holeDir.z) != 0 || holePos.z <= 0 || holePos.z >= node.Thickness) continue;

				holeEndPos = node.GlobalToObject(hole.EndPosition);
				if (node.Contour.IsPointInside(holeEndPos)) {
					hdx = rnd2(holeDir.x);
					hdy = rnd2(holeDir.y);
					holeEndPos = node.GlobalToObject(hole.EndPosition);
					for (var j = 0; j < node.Contour.Count; j++) {
						contour = node.Contour[j];
						contourButt = contour.Data != null && contour.Data.Butt != null ? contour.Data.Butt : null;
						var bt = (contourButt != null && contourButt.ClipPanel == false) ? contourButt.Thickness : 0;
						if ((rnd2(contour.DistanceToPoint(holePos) + contour.DistanceToPoint(holeEndPos)) == rnd2(hole.obj.Depth) && (rnd2(contour.DistanceToPoint(holeEndPos) + bt) > 2))) {
							dp = rnd2(contour.DistanceToPoint(holeEndPos) + bt);
							if (hdx == 1) {
								bHor.push(new Bore(2, hole.obj.Diameter, 0, part.cw - holePos.y + minY, part.thick - holePos.z, dp,holeDir,holePos));
								hole.used = isEqualFloat(dp, hole.obj.Depth);
								break;
							} else if (hdx == -1) {
								bHor.push(new Bore(3, hole.obj.Diameter, 0, part.cw - holePos.y + minY, part.thick - holePos.z, dp,holeDir,holePos));
								hole.used = isEqualFloat(dp, hole.obj.Depth);;
								break;
							} else if (hdx == 0) {
								if (hdy == 1) {
									bHor.push(new Bore(1, hole.obj.Diameter, holePos.x - minX, 0, part.thick - holePos.z, dp,holeDir,holePos));
								} else if (hdy == -1) {
									bHor.push(new Bore(0, hole.obj.Diameter, holePos.x - minX, 0, part.thick - holePos.z, dp,holeDir,holePos));
								}
								hole.used = isEqualFloat(dp, hole.obj.Depth);
								break;
							}
						}
					}
				}
			}

			if (part.bFront.length == 0 && part.cFront.length == 0 && (part.bBack.length > 0 || part.cBack.length > 0)) {
				part.offsetX = part.dl - (part.cl + (minX - node.GMin.x));
				var te = part.el[2];
				part.el[2] = part.el[3];
				part.el[3] = te;
				//bore
				part.bFront = part.bFront.concat(part.bBack);
				if (bThrough.length > 0)
					part.bFront = part.bFront.concat(bThrough);
				if (bHor.length > 0)
					part.bFront = part.bFront.concat(bHor);
				part.bBack = [];
				//cut
				part.cFront = part.cFront.concat(part.cBack);
				if (cThrough.length > 0)
					part.cFront = part.cFront.concat(cThrough);
				part.cBack = [];
				//
				for (var bi = 0; bi < part.bFront.length; bi++) {
					var bore = part.bFront[bi];
					switch (bore.plane) {
						case 0:
						case 1:
							bore.x = part.cl - bore.x;
							bore.z = part.thick - bore.z;
							break;
						case 2:
							bore.plane = 3;
							bore.z = part.thick - bore.z;
							break;
						case 3:
							bore.plane = 2;
							bore.z = part.thick - bore.z;
							break;
						case 4:
						case 5:
                            if (bore.plane == 5 && bore.x - part.cl <= bore.d)
                            {
                                break;   
                            }
							bore.x = part.cl - bore.x;
							break;
					}
				}
				for (var ci = 0; ci < part.cFront.length; ci++) {
					var cut = part.cFront[ci];
					cut.offset = -cut.offset;
					for (var i = 0; i < cut.path.length; i++) {
						elem = cut.path[i];
						if (elem.Type == 1) {
							elem.sx = part.cl - elem.sx;
							elem.ex = part.cl - elem.ex;
						} else if (elem.Type == 2) {
							elem.sx = part.cl - elem.sx;
							elem.ex = part.cl - elem.ex;
							elem.cx = part.cl - elem.cx;
							elem.dir = !elem.dir;
						} else if (elem.Type == 3) {
							elem.cx = part.cl - elem.cx;
						}
					}
				}
				for (var j = 0; j < part.contour.length; j++) {
					contour = part.contour[j];
					if (contour.path[0].Type != 3)
						contour.clockOtherWise = !contour.clockOtherWise;
					for (var i = 0; i < contour.path.length; i++) {
						contElement = contour.path[i];
						if (contElement.Type == 1) {
							contElement.sx = part.cl - contElement.sx;
							contElement.ex = part.cl - contElement.ex;
						} else if (contElement.Type == 2) {
							contElement.sx = part.cl - contElement.sx;
							contElement.ex = part.cl - contElement.ex;
							contElement.cx = part.cl - contElement.cx;
							contElement.dir = !contElement.dir;
						} else if (contElement.Type == 3) {
							contElement.cx = part.cl - contElement.cx;
						}
					}
				}
			} else if (bThrough.length > 0 || bHor.length > 0 || cThrough.length > 0) {
				part.bFront = part.bFront.concat(bThrough, bHor);
				part.cFront = part.cFront.concat(cThrough);
			}

			part.bExThrough = bThrough.length > 0;
			part.cExThrough = cThrough.length > 0;
			part.bFront.sort(sortBores);
			part.bBack.sort(sortBores);

			var hole = [];
			for(var i = 0; i < part.bFront.length; i += 1){
				var h = part.bFront[i];
				hole.push({
					type: 'front',
					x: h.x,
					y: h.y,
					z: h.z,
					d: h.d,
					dp: h.dp,
					side: part.bFront[i].plane,
					type: h.dp >= part.thick ? 'through' : 'noThrough'
				});
			}

			

			for(var i = 0; i < part.bBack.length; i += 1){
				var h = part.bBack[i];
				hole.push({
					type: 'back',
					x: h.x,
					y: h.y,
					z: h.z,
					d: h.d,
					dp: h.dp,
					side: part.bBack[i].plane,
					type: h.dp >= part.thick ? 'through' : 'noThrough'
				});
			}


			return {
				hole: hole
			};
		}

       function GetCuts(cuts, panel, node,widthDif) {
            var res = [],
                msg4mm = true,
                msgRect = true;

			let flipCuts = false;
			for (var i = 0; i < holes.length; i++) {
						var hole,
						holePos,
						holeDir,
						hz,

				hole = holes[i];
				holePos = node.GlobalToObject(hole.Position);
				if (holePos.z < -(hole.obj.Depth + node.Thickness) || (holePos.z > hole.obj.Depth + node.Thickness))
					continue;
				holeDir = node.NToObject(hole.Direction);

				if (rnd2(Math.abs(holeDir.z)) == 1 && node.Contour.IsPointInside(holePos)) {
					hz = holePos.z;

					if (holeDir.z > 0.001) {
						if (hz <= 0.001 && (hz + hole.obj.Depth) > 0) {
							depth = rnd2(hz + hole.obj.Depth);
							if (Math.round(node.Thickness * 10) > Math.round(depth * 10))
							{
								flipCuts = true;
								break;
							}
						}
					}
				}
			}

            for (var i = 0; i < cuts.Count; i++) {
                var cutObj = cuts[i];
                var cut = {};

                //   
                if (!cutObj.Trajectory || cutObj.Trajectory.Count === 0) continue;

                //    
                if (CheckGrooveOnRect(cutObj) > 0) {
                    if (msgRect) {
                        alert('    ');
                        msgRect = false;
                    }
                    continue;
                }

                //   
                if (cutObj.Contour.Width !== 4) {
                    if (msg4mm) {
                        alert(',     4   ');
                        msg4mm = false;
                    }
                    continue;
                }

                //     
                var cMinX = Infinity, cMaxX = -Infinity;
                var cMinY = Infinity, cMaxY = -Infinity;

                for (var j = 0; j < cutObj.Contour.Count; j++) {
                    var elem = cutObj.Contour[j];
                    //  / 
                    cMinX = Math.min(cMinX, elem.Pos1.x, elem.Pos2.x);
                    cMaxX = Math.max(cMaxX, elem.Pos1.x, elem.Pos2.x);
                    cMinY = Math.min(cMinY, elem.Pos1.y, elem.Pos2.y);
                    cMaxY = Math.max(cMaxY, elem.Pos1.y, elem.Pos2.y);
                }

                //   
                var traj = cutObj.Trajectory[0];
                if (rnd1(traj.Pos1.x) === rnd1(traj.Pos2.x)) {
                    //  
                    cut.dir = 'v';
                    //    / 
                    if (traj.Pos1.x <= 0) {
                        if (flipCuts)
                        {
                            //alert(' W:'+node.ContourWidth + '\n cMinX :' + cMinX + '\n cMaxX: ' + cMaxX + '\n : ' + (node.ContourWidth - cMinX + widthDif));
                            cut.pos = rnd1(node.ContourWidth - cMinX + widthDif); 
                        }
                        else
                        {
                            cut.pos = rnd1(cMinX);
                        }
                    } else {
                        if (flipCuts)
                        {
                            cut.pos = rnd1(cMaxX); 
                        }
                        else
                        {
                            cut.pos = rnd1(node.ContourWidth - cMaxX + widthDif);
                        }
                    }
                } else if (rnd1(traj.Pos1.y) === rnd1(traj.Pos2.y)) {
                    //  
                    cut.dir = 'h';
                    //    / 
                    if (traj.Pos1.y <= 0) {
                        cut.pos = cMinY; //   
                    } else {
                        cut.pos = panel.ContourHeight - cMaxY; //   
                    }
                } else {
                    continue;
                }
                //   
                cut.name = cutObj.Name;
                cut.depth = cutObj.Contour.Height;
                cut.width = cutObj.Contour.Width;
                cut.sign = cutObj.Sign;
                cut.side = GetSideOfCut(cutObj, panel.thickness);

                res.push(cut);
            }

            return {
                cut: res
            };

			function CheckGrooveOnRect(c) {
				var res = 0;
				for (var j = 0; j < c.Contour.Count; j++) {
					var elem = c.Contour[j];
					if(elem instanceof T2DArc){
						return 0;
					}

					if (elem.ElType != 1) {
						res = 1;
						break;
					}
					if (elem.ElType == 1 && !(isEqualFloat(elem.Pos1.x, elem.Pos2.x) || isEqualFloat(elem.Pos1.y, elem.Pos2.y))) {
						res = 2;
						break;
					}
				}

				if (rnd1(c.Trajectory[0].Pos1.x) !== rnd1(c.Trajectory[0].Pos2.x) && rnd1(c.Trajectory[0].Pos1.y) !== rnd1(c.Trajectory[0].Pos2.y)) {
					res = 3;
				}
				return res;
			}

			function GetSideOfCut(c, partThickness) {
				var res,
					cMinX = Infinity,
					cMaxX = -cMinX,
					cMinY = Infinity,
					cMaxY = -cMinY;

				if (c.Contour.Max == undefined) {
					for (var j = 0; j < c.Contour.Count; j++) {
						var elem = c.Contour[j];
						if (elem.ElType == 1 || elem.ElType == 2) {
							if (cMinX > elem.Pos1.x)
								cMinX = elem.Pos1.x;
							else if (cMaxX < elem.Pos1.x)
								cMaxX = elem.Pos1.x;
							if (cMinY > elem.Pos1.y)
								cMinY = elem.Pos1.y;
							else if (cMaxY < elem.Pos1.y)
								cMaxY = elem.Pos1.y;
							if (cMinX > elem.Pos2.x)
								cMinX = elem.Pos2.x;
							else if (cMaxX < elem.Pos2.x)
								cMaxX = elem.Pos2.x;
							if (cMinY > elem.Pos2.y)
								cMinY = elem.Pos2.y;
							else if (cMaxY < elem.Pos2.y)
								cMaxY = elem.Pos2.y;
						} else if (elem.ElType == 3) {
							if (cMinX > (elem.Center.x - elem.CirRadius))
								cMinX = elem.Center.x - elem.CirRadius;
							else if (cMaxX < (elem.Center.x + elem.CirRadius))
								cMaxX = elem.Center.x + elem.CirRadius;
							if (cMinY > (elem.Center.y - elem.CirRadius))
								cMinY = elem.Center.y - elem.CirRadius;
							else if (cMaxY < (elem.Center.y + elem.CirRadius))
								cMaxY = elem.Center.y + elem.CirRadius;
						} else {
							alert('  ');
						}
					}
				} else {
					cMinX = c.Contour.Min.x;
					cMaxX = c.Contour.Max.x;
					cMinY = c.Contour.Min.y;
					cMaxY = c.Contour.Max.y;
				}


				if (cMaxY >= (partThickness - 0.001)) {
					res = 'front';
				} else if (cMinY <= 0.001) {
					res = 'back';
				}
				return res;
			}

			return {
				cut: res
			};
		}

		function getDistance(x1, y1, x2, y2) {
				return Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
			}


		var count = 0;
		function ShowStructureInConsole(obj, lvl, recursive, showFunctions) {
			count += 1;
			if (count > 200) return;
			var to, value, isEmpty;

			for (var key in obj) {

				to = typeof(obj[key]);
				if (!showFunctions && to === 'function') continue;

				if (to === 'number' || to === 'string' || to === 'boolean') {
					value = obj[key];
				} else if (to === 'object') {
					isEmpty = CheckObjOnEmpty(obj[key]);
					if (isEmpty) {
						value = 'empty';
					} else {
						value = 'haveProperties';
					}
				} else if (to === 'function') {
					value = 'function';
				} else if (to === 'undefined') {
					value = 'undefined';
				} else {
					value = 'something new';
				}

				console.log((lvl + ' ' + key + ' - ' + to + ' - ' + value));

				if (recursive && to === 'object') {
					ShowStructureInConsole(obj[key], (lvl + '-'));
				}
			}
		}

		function CheckObjOnEmpty(obj) {
			for (var prop in obj) {
				if (obj.hasOwnProperty(prop)) {
					return false;
				}
			}

			return JSON.stringify(obj) === JSON.stringify({});
		}

		function GetObjType(obj) {
			var res = null;
			for (var key in obj) {
				if (key === 'TextureOrientation') {
					res = 'panel';
				} else if(key === 'Holes'){
					res = 'furniture';
				}
			}
			return res;
		}

		SetMetaInfo();
		GatherHolesInfo(Model);
		GatherPanelInfo(Model);

		xotree = new XML.ObjTree();
		xml = xotree.writeXML(Doc);

		let filename = system.askFileNameSave('xml');

		//    Windows-1251
		const buffer = iconvLite.encode(xml, 'windows-1251');
		
		//     
		fs.writeFileSync(filename, buffer);

		alert(' ');
	}
	catch(e) {
		let errorInfo = ': ' + e.message;
		
		//    ,  
		if (e.lineNumber !== undefined) {
			errorInfo += '\n: ' + e.lineNumber;
		}
		
		//     
		if (e.stack) {
			errorInfo += '\n :\n' + e.stack;
		}
		
		alert(errorInfo);
	}